<?php

// autoload_runtime.php @generated by Symfony Runtime

if (true === (require_once __DIR__.'/autoload.php') || empty($_SERVER['SCRIPT_FILENAME'])) {
    return;
}

use App\Kernel;
use Symfony\Component\HttpFoundation\Request;

require __DIR__ . '/../config/bootstrap.php';

$kernel = new Kernel($_SERVER['APP_ENV'], (bool)$_SERVER['APP_DEBUG']);

$configValues = $kernel->getConfigValues() ?? [];
$installerLocked = $configValues['installed_locked'] ?? false;

if (!$installerLocked && file_exists('legacy/config.php') && !empty($_POST['install-checked'])){
    header('Location: .');
    return;
}

if (!file_exists('legacy/config.php') && !file_exists('../.installed_checked') && !file_exists('../.curl_check_main_page')) {

    if (empty($_POST['install-checked'])) {
        header('Location: install.php');
        return;
    }

    file_put_contents('../.installed_checked', true);
    header('Location: .');
    return;
} else if (!$installerLocked && file_exists('../.installed_checked') && !empty($_POST['install-checked'])) {
    header('Location: .');
    return;
}

// Get the autoloader class

$request = Request::createFromGlobals();

$kernel->init();

global $legacyRoute;

$legacyRoute = $kernel->getLegacyRoute($request);

if (!empty($legacyRoute)) {

    $path = './legacy';
    if (!empty($legacyRoute['dir'])) {
        $path .= '/' . $legacyRoute['dir'];
    }

    chdir($path);

    $access = $legacyRoute['access'] ?? false;
    if ($access === false) {
        http_response_code(403);
        exit;
    }

    if (file_exists($legacyRoute['file'])) {

        /* @noinspection PhpIncludeInspection */
        require './' . $legacyRoute['file'];
    } else {

        http_response_code(404);
        exit;
    }
    exit;
}

$app = require $_SERVER['SCRIPT_FILENAME'];

if (!is_object($app)) {
    throw new TypeError(sprintf('Invalid return value: callable object expected, "%s" returned from "%s".', get_debug_type($app), $_SERVER['SCRIPT_FILENAME']));
}

$runtime = $_SERVER['APP_RUNTIME'] ?? $_ENV['APP_RUNTIME'] ?? 'Symfony\\Component\\Runtime\\SymfonyRuntime';
$runtime = new $runtime(($_SERVER['APP_RUNTIME_OPTIONS'] ?? $_ENV['APP_RUNTIME_OPTIONS'] ?? []) + [
  'project_dir' => dirname(__DIR__, 1),
]);

[$app, $args] = $runtime
    ->getResolver($app)
    ->resolve();

$app = $app(...$args);

exit(
    $runtime
        ->getRunner($app)
        ->run()
);
